/*
 * Decompiled with CFR 0.152.
 */
package cc.ewan.genes.model;

import cc.ewan.genes.model.InvalidGenderException;
import cc.ewan.genes.model.Life;
import cc.ewan.genes.model.Marriage;
import cc.ewan.genes.model.UniquelyIdentified;
import cc.ewan.genes.model.state.event.AddStateChangeEvent;
import cc.ewan.genes.model.state.event.AlterStateChangeEvent;
import cc.ewan.genes.model.state.event.RemoveStateChangeEvent;
import cc.ewan.genes.utils.DateFormatter;
import cc.ewan.genes.utils.UniqueId;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class Individual
extends Observable
implements UniquelyIdentified {
    protected String uid = UniqueId.generate();
    private String name;
    private String gender;
    private String wills;
    private String notes;
    protected Life life;
    private SortedMap marriages = new TreeMap();
    private Individual father;
    private Individual mother;
    private Hashtable children;

    public Individual() {
        this.setFather(null);
        this.mother = null;
        this.children = new Hashtable();
    }

    protected abstract Marriage newMarriage();

    protected abstract Marriage newMarriage(String var1);

    protected abstract Life newLife();

    public Individual(String name, String gender, Date birthDate) {
        this();
        this.name = name;
        this.setGender(gender);
        this.life = this.newLife();
        this.life.setStart(birthDate);
    }

    public String getUID() {
        return this.uid;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name + "^" + this.gender + "^" + DateFormatter.reformat((Date)this.life.getStart());
    }

    public String getGender() {
        return this.gender;
    }

    protected void setGender(String gender) {
        if (!"M".equals(gender) && !"F".equals(gender)) {
            throw new InvalidGenderException("M or F", gender);
        }
        this.gender = gender;
    }

    public String getWills() {
        return this.wills;
    }

    public void setWills(String wills) {
        this.wills = wills;
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public Date getBirthDate() {
        return this.life.getStart();
    }

    public Date getDeathDate() {
        return this.life.getEnd();
    }

    public void setDeathDate(Date deathDate) {
        this.life.setEnd(deathDate);
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public Marriage marry(Individual spouse, Date weddingDate) {
        return this.marry(spouse, weddingDate, null);
    }

    public Marriage marry(Individual spouse, Date weddingDate, String uid) {
        Marriage marriage = this.newMarriage(uid);
        marriage.setStart(weddingDate);
        marriage.setPartners(this, spouse);
        this.addMarriage(marriage);
        spouse.addMarriage(marriage);
        this.setChanged();
        this.notifyObservers(new AddStateChangeEvent(marriage));
        return marriage;
    }

    protected void addMarriage(Marriage marriage) {
        this.marriages.put(marriage.toString(), marriage);
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public void unmarry(Marriage marriage) {
        this.removeMarriage(marriage);
        marriage.getPartner(this).removeMarriage(marriage);
        this.setChanged();
        this.notifyObservers(new RemoveStateChangeEvent(marriage));
    }

    protected void removeMarriage(Marriage marriage) {
        this.marriages.remove(marriage.toString());
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public Collection getMarriages() {
        return this.marriages.values();
    }

    public Individual getFather() {
        return this.father;
    }

    public void setFather(Individual father) {
        if (father != null && !"M".equals(father.getGender())) {
            throw new InvalidGenderException("M", father.getGender());
        }
        if (this.father != null) {
            this.father.removeChild(this);
        }
        this.father = father;
        if (father != null) {
            father.addChild(this);
        }
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public Individual getMother() {
        return this.mother;
    }

    public void setMother(Individual mother) {
        if (mother != null && !"F".equals(mother.getGender())) {
            throw new InvalidGenderException("F", mother.getGender());
        }
        if (this.mother != null) {
            this.mother.removeChild(this);
        }
        this.mother = mother;
        if (mother != null) {
            mother.addChild(this);
        }
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public Collection getChildren() {
        return this.children.values();
    }

    protected void addChild(Individual child) {
        this.children.put(child.toString(), child);
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    protected void removeChild(Individual child) {
        this.children.remove(child.toString());
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public void dispose() {
        this.setChanged();
        this.notifyObservers(new RemoveStateChangeEvent(this));
        this.deleteObservers();
        for (Individual child : ((Map)this.children.clone()).values()) {
            if (child.getFather() == this) {
                child.setFather(null);
            }
            if (child.getMother() != this) continue;
            child.setMother(null);
        }
        if (this.children.size() != 0) {
            System.err.println("All children orphaned, but size=" + this.children.size());
        }
        HashSet marriages = new HashSet(this.marriages.values());
        Iterator<Object> i = marriages.iterator();
        while (i.hasNext()) {
            this.unmarry((Marriage)i.next());
        }
        if (this.marriages.size() != 0) {
            System.err.println("All marriages removed, but size=" + this.marriages.size());
        }
        this.setFather(null);
        this.setMother(null);
    }
}

