/*
 * Decompiled with CFR 0.152.
 */
package cc.ewan.genes.model;

import cc.ewan.genes.model.Event;
import cc.ewan.genes.model.Individual;
import cc.ewan.genes.model.UniquelyIdentified;
import cc.ewan.genes.model.state.event.AlterStateChangeEvent;
import cc.ewan.genes.utils.UniqueId;

public abstract class Marriage
extends Event
implements UniquelyIdentified {
    private String uid;
    private Individual husband;
    private Individual wife;

    public Marriage() {
        this(UniqueId.generate());
    }

    protected Marriage(String uid) {
        this.uid = uid;
    }

    public String getUID() {
        return this.uid;
    }

    public String toString() {
        return this.husband + "^" + this.getStart();
    }

    public Individual getPartner(Individual me) {
        if (this.husband == me) {
            return this.wife;
        }
        return this.husband;
    }

    public void setPartner(Individual p) {
        if (p.getGender().equals("M")) {
            this.husband = p;
        } else {
            this.wife = p;
        }
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public void setPartners(Individual p1, Individual p2) {
        if (p1.getGender().equals("M")) {
            this.husband = p1;
            this.wife = p2;
        } else {
            this.wife = p1;
            this.husband = p2;
        }
        this.setChanged();
        this.notifyObservers(new AlterStateChangeEvent(this));
    }

    public Individual getHusband() {
        return this.husband;
    }

    public Individual getWife() {
        return this.wife;
    }
}

