/*
 * Decompiled with CFR 0.152.
 */
package cc.ewan.genes.model.state;

import cc.ewan.genes.model.state.InvalidationListener;
import cc.ewan.genes.model.state.Model;
import cc.ewan.genes.model.state.ModelSerialImpl;
import cc.ewan.genes.model.state.event.AddStateChangeEvent;
import cc.ewan.genes.model.state.event.AlterStateChangeEvent;
import cc.ewan.genes.model.state.event.RemoveStateChangeEvent;
import cc.ewan.genes.utils.PassiveFileMonitor;
import java.io.File;

public class InvalidationListenerSerialImpl
extends InvalidationListener {
    String stateFileName;
    PassiveFileMonitor fileMonitor;

    public InvalidationListenerSerialImpl(Model model) {
        super(model);
        this.stateFileName = ((ModelSerialImpl)model).getStateFileName();
        this.fileMonitor = new PassiveFileMonitor(new File(this.stateFileName));
    }

    public void run() {
        boolean interrupted = false;
        while (!interrupted) {
            try {
                Thread.sleep(5000L);
                if (this.fileMonitor.isCreated()) {
                    this.setChanged();
                    this.notifyObservers(new AddStateChangeEvent(this.getModel()));
                    continue;
                }
                if (this.fileMonitor.isRemoved()) {
                    this.setChanged();
                    this.notifyObservers(new RemoveStateChangeEvent(this.getModel()));
                    continue;
                }
                if (!this.fileMonitor.isChanged()) continue;
                this.setChanged();
                this.notifyObservers(new AlterStateChangeEvent(this.getModel()));
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
    }
}

