/*
 * Decompiled with CFR 0.152.
 */
package cc.ewan.genes.model.state;

import cc.ewan.genes.model.Individual;
import cc.ewan.genes.model.Marriage;
import cc.ewan.genes.model.state.event.AddStateChangeEvent;
import cc.ewan.genes.model.state.event.RemoveStateChangeEvent;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

public abstract class Model
extends Observable
implements Observer {
    private String stateId;
    protected Hashtable individuals = new Hashtable(1000);
    protected Hashtable marriages = new Hashtable(1000);

    public abstract void save() throws Exception;

    public abstract Model restore() throws Exception;

    public abstract void purge() throws Exception;

    public void dump(PrintStream out) {
        out.println("Individuals: #" + this.individuals.size());
        for (Individual individual : this.individuals.values()) {
            out.println("  " + individual);
            if (individual.getChildren().size() > 0) {
                out.println("    Children: #" + individual.getChildren().size());
            }
            if (individual.getMarriages().size() <= 0) continue;
            out.println("    Marriages: #" + individual.getMarriages().size());
        }
    }

    protected String getStateId() {
        return this.stateId;
    }

    protected void setStateId(String stateId) {
        this.stateId = stateId;
    }

    public synchronized void addIndividual(Individual i) {
        i.addObserver(this);
        this.individuals.put(i.toString(), i);
        this.setChanged();
        this.notifyObservers(new AddStateChangeEvent(i));
    }

    public synchronized void removeIndividual(Individual i) {
        this.individuals.remove(i.toString());
        i.dispose();
    }

    public synchronized void update(Observable o, Object e) {
        RemoveStateChangeEvent event;
        if (e instanceof AddStateChangeEvent) {
            AddStateChangeEvent event2 = (AddStateChangeEvent)e;
            if (event2.getElement() instanceof Marriage) {
                ((Observable)event2.getElement()).addObserver(this);
                this.marriages.put(event2.getElement().toString(), event2.getElement());
            }
        } else if (e instanceof RemoveStateChangeEvent && (event = (RemoveStateChangeEvent)e).getElement() instanceof Marriage) {
            ((Observable)event.getElement()).deleteObserver(this);
            this.marriages.remove(event.getElement().toString());
        }
        this.setChanged();
        this.notifyObservers(e);
    }

    public Collection getIndividuals() {
        return this.individuals.values();
    }
}

