/*
 * Decompiled with CFR 0.152.
 */
package cc.ewan.genes.model.state;

import cc.ewan.genes.model.Individual;
import cc.ewan.genes.model.IndividualSerialImpl;
import cc.ewan.genes.model.state.InvalidationListener;
import cc.ewan.genes.model.state.InvalidationListenerSerialImpl;
import cc.ewan.genes.model.state.Model;
import cc.ewan.genes.model.state.ModelSerialImpl;
import java.util.Date;

public class ModelFactory {
    private Model model;

    public Model newModel(String id) {
        this.model = new ModelSerialImpl();
        try {
            this.model.setStateId(id);
            this.model = this.model.restore();
        }
        catch (Exception e) {
            System.err.println("No model to restore: " + e);
        }
        return this.model;
    }

    public InvalidationListener newInvalidationListener(Model m) {
        InvalidationListenerSerialImpl l = new InvalidationListenerSerialImpl(m);
        Thread t = new Thread(l);
        l.setThread(t);
        t.setDaemon(true);
        t.start();
        return l;
    }

    public Individual newIndividual(String name, String gender, Date birthDate) {
        return new IndividualSerialImpl(name, gender, birthDate);
    }
}

