/*
 * Decompiled with CFR 0.152.
 */
package cc.ewan.genes.model.state;

import cc.ewan.genes.model.Individual;
import cc.ewan.genes.model.IndividualSerialImpl;
import cc.ewan.genes.model.Marriage;
import cc.ewan.genes.model.state.Model;
import cc.ewan.genes.utils.Serialise;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ModelSerialImpl
extends Model
implements Serializable {
    protected String getStateFileName() {
        return "/var/tmp/state." + this.getStateId() + ".bin";
    }

    public void save() throws Exception {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.getStateFileName()));
        os.writeObject(this);
    }

    public Model restore() throws Exception {
        ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.getStateFileName()));
        return (Model)is.readObject();
    }

    public void purge() throws Exception {
        File f = new File(this.getStateFileName());
        f.delete();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getStateId());
        Serialise.writeMap((ObjectOutputStream)out, (Map)this.individuals);
        Hashtable<String, String> parents = new Hashtable<String, String>();
        for (Individual child : this.individuals.values()) {
            if (child.getFather() == null) continue;
            parents.put(child.toString(), child.getFather().toString());
        }
        Serialise.writeMap((ObjectOutputStream)out, parents);
        parents = new Hashtable();
        for (Individual child : this.individuals.values()) {
            if (child.getMother() == null) continue;
            parents.put(child.toString(), child.getMother().toString());
        }
        Serialise.writeMap((ObjectOutputStream)out, parents);
        out.writeObject(this.marriages.size());
        for (Marriage m : this.marriages.values()) {
            out.writeObject(m.getHusband().toString());
            out.writeObject(m.getWife().toString());
            out.writeObject(m.getStart());
            out.writeObject(m.getEnd());
            out.writeObject(m.getUID());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Individual parent;
        Individual child;
        in.defaultReadObject();
        this.setStateId((String)in.readObject());
        Serialise.readMap((ObjectInputStream)in, (Map)this.individuals);
        Iterator<Object> i = this.getIndividuals().iterator();
        while (i.hasNext()) {
            ((Individual)i.next()).addObserver(this);
        }
        Hashtable parents = new Hashtable();
        Serialise.readMap((ObjectInputStream)in, parents);
        i = parents.keySet().iterator();
        while (i.hasNext()) {
            child = (Individual)this.individuals.get(i.next());
            parent = (Individual)this.individuals.get(parents.get(child.toString()));
            child.setFather(parent);
        }
        parents = new Hashtable();
        Serialise.readMap((ObjectInputStream)in, parents);
        i = parents.keySet().iterator();
        while (i.hasNext()) {
            child = (Individual)this.individuals.get(i.next());
            parent = (Individual)this.individuals.get(parents.get(child.toString()));
            child.setMother(parent);
        }
        int marriagesCount = (Integer)in.readObject();
        for (int j = 0; j < marriagesCount; ++j) {
            String husbandString = (String)in.readObject();
            String wifeString = (String)in.readObject();
            Date marriageDate = (Date)in.readObject();
            Date divorceDate = (Date)in.readObject();
            String uid = (String)in.readObject();
            IndividualSerialImpl husband = (IndividualSerialImpl)this.individuals.get(husbandString);
            Individual wife = (Individual)this.individuals.get(wifeString);
            husband.marry(wife, marriageDate, uid).setEnd(divorceDate);
        }
    }
}

